package gov.va.med.domain.model;

import java.util.Date;

import gov.va.med.framework.bean.AbstractVO;
/**
 * Super class for all PHR payloads when a extract requets is 
 * made.  Subclasses will extend to contain specific 
 * Business Objects as needed for the request.  
 */
public class PHRRequestPayload extends AbstractVO implements IPayload
{ 
    private static final long serialVersionUID = 3257009873404311601L;
    private String _requestId;
    private Patient _patient;
    private Date _fromDate = null;
    private Date _toDate = null;
    
    public PHRRequestPayload(String requestId, 
                             Patient patient,
                             Date fromDate, Date toDate)
    
    {
        setRequestId(requestId);
        setPatient(patient);
        setFromDate(fromDate);
        setToDate(toDate);
    }
    public PHRRequestPayload(Patient patient) {
        setPatient(patient);
    }
    public String getRequestId()                {return _requestId;}
    public Patient getPatient()                 {return _patient;}
    public Date getFromDate()                   {return _fromDate;}
    public Date getToDate()                     {return _toDate;}
    
    public void setRequestId(String value)      {_requestId = value;}
    public void setPatient(Patient patient)     {_patient=patient;}
    public void setFromDate(Date value)         {_fromDate = value;}
    public void setToDate(Date value)           {_toDate = value;}
} 
